* rt-ssur2.prg
* v1.0
*
* Forecast unemployment rate using real-time data

calendar 1951 1 12
allocate 2100:12

declare integer FIRSTOBS LASTOBS ESTEND ESTBEG FCBEG FCEND FCLEN

open data input.csv
data(format=cdf, org=col) / E U U_S HWI UIC
close data

** locate last observation for UR
set ur = U/(U+E)
inquire(series=ur) FIRSTOBS LASTOBS
set urdata = ur

*************************************************
*** PARAMETERS FOR ESTIMATION AND FORECASTING ***
*************************************************
compute NLAGS=2;                    * Number of lags in VAR
compute ESTEND=LASTOBS;             * End date for VAR estimation
compute ESTBEG=ESTEND-179;          * Start date for VAR estimation
compute FCLEN=24;                   * Forecast length
compute FCBEG=ESTEND+1;             * Starting date for UR forecast
compute FCEND=FCBEG+FCLEN;          * Last date for which forecasts are desired

****************************************
*** COMPUTE HAZARD RATES FROM STOCKS ***
****************************************
set bigF = 1 - ((U{-1} - U_S{-1})/U)
set f = -log(1-bigF)
* set up s series
set s = %na
* iterate
do i = FIRSTOBS,LASTOBS-1
  compute Ei = E(i)
  compute Ui = U(i)
  compute U1i = U(i+1)
  compute fi = f(i)
  nonlin x
  * guess average s
  compute xs = 0.0345
  * transform xs in [0,1] to x in [-inf,inf]
  compute x = log(xs/(1-xs))
  compute value = 0.0
  find(method=genetic,iterations=100,subiterations=100000,cvcrit=0.0001,noprint) root value
    * x in [-inf,inf]; xs in [0,1]
    compute xs = exp(x)/(1+exp(x))
    compute value = U1i - (Ui+Ei)*xs*(1-exp(-fi-xs))/(fi+xs) - Ui*exp(-fi-xs)
  end find
  set s i i = xs
end do
*
*print(picture="#.#####") / s f ur

***************************************
*** ESTIMATE AND SIMULATE VAR MODEL ***
***************************************
* logs of variables
set ls = log(s)
set lf = log(f)
set lur = log(ur)
set luic = log(uic)
set lhwi = log(hwi)
* define VAR here
system(model=var)
variables ls lf lur lhwi luic
lags 1 to NLAGS
det constant
end(system)
*
estimate(model=var) ESTBEG ESTEND
forecast(model=var,from=FCBEG-1,to=FCEND,results=fcasts)

*** UR FORECAST FROM VAR ***
set ur_var = urdata
set ur_var FCBEG FCEND = exp(fcasts(3))

********************************
*** STORE SERIES TO CSV FILE ***
********************************
open(noappend) copy output.csv
copy(format=cdf,dates,org=columns) FIRSTOBS FCEND ur_var
close copy
